#!/bin/bash


find /var/atlassian/application-data/bamboo /opt/atlassian/bamboo/current/ -iname *.jar | while read i; do 
  if [ `jar -tvf $i | grep "Version2LicenseDecoder" | wc -l` -gt 0 ]; 
    then
      echo $i
      jar -uvf $i com/atlassian/extras/decoder/v2/Version2LicenseDecoder.class
    fi
  done

# flush the bamboo caches
rm -rf /var/atlassian/application-data/bamboo/caches/plugins/felix/felix-cache/bundle*

# Update the bundled plugin.  Sneaky update thanks Atlassian
unzip /opt/atlassian/bamboo/current/atlasian-bamboo/WEB-INF/classes/atlassian-bundled-plugins.zip atlassian-universal-plugin-manager-plugin-2.15.jar
jar -uvf atlassian-universal-plugin-manager-plugin-2.15.jar com/atlassian/extras/decoder/v2/Version2LicenseDecoder.class
zip -f /opt/atlassian/bamboo/current/atlasian-bamboo/WEB-INF/classes/atlassian-bundled-plugins.zip atlassian-universal-plugin-manager-plugin-2.15.jar

