/*
 * Decompiled with CFR 0.152.
 */
package nl.invisible.keygen.gui;

import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import nl.invisible.keygen.gui.AboutBox;
import nl.invisible.keygen.gui.JarFileFilter;
import nl.invisible.keygen.gui.MainApp;
import nl.invisible.keygen.license.KeyConstants;
import nl.invisible.keygen.license.LicenseFile;
import nl.invisible.keygen.patch.Patch;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class MainWindow
extends FrameView
implements KeyConstants {
    private JButton aboutButton;
    private JLabel appNameLabel;
    private JButton cancelButton;
    private JLabel emailLabel;
    private JTextField emailText;
    private JButton genButton;
    private JTextArea keyBox;
    private JScrollPane keyBoxScrollPane;
    private JLabel keyLabel;
    private JPanel mainPanel;
    private JLabel nameLabel;
    private JTextField nameText;
    private JLabel orgLabel;
    private JTextField orgText;
    private JButton patchButton;
    private JLabel serverIDLabel;
    private JTextField serverIDText;
    private JLabel statusLabel;
    private JDialog aboutBox;
    private boolean firstTimeCallingFChooser = true;
    private JFileChooser fileChooser;
    private String jarFilePath;

    public MainWindow(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.getFrame().setResizable(false);
        this.getFrame().setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/nl/invisible/keygen/gui/resources/invblue-icon.png")));
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = MainApp.getApplication().getMainFrame();
            this.aboutBox = new AboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        MainApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void patchApp() {
        Patch patch = new Patch();
        this.patchButton.setEnabled(false);
        this.statusLabel.setText("Patching...");
        if (this.showFileChooser() && patch.patchFile(this.jarFilePath)) {
            this.statusLabel.setText("Jar successfully patched.");
        } else {
            this.statusLabel.setText("Error patching jar.");
            this.patchButton.setEnabled(true);
        }
    }

    @Action
    public void genLicense() {
        String name = this.nameText.getText().trim();
        String email = this.emailText.getText().trim();
        String org = this.orgText.getText().trim();
        String sid = this.serverIDText.getText().trim();
        if (name.equals("") || name == null) {
            this.statusLabel.setText("Enter your name.");
        } else if (name.length() < 5) {
            this.statusLabel.setText("Name too short.");
        } else if (name.length() > 100) {
            this.statusLabel.setText("Name too long.");
        } else if (email.equals("") || email == null) {
            this.statusLabel.setText("Enter your email.");
        } else if (!email.contains("@")) {
            this.statusLabel.setText("Enter a real email.");
        } else if (email.length() < 5) {
            this.statusLabel.setText("Email too short.");
        } else if (email.length() > 100) {
            this.statusLabel.setText("Email too long.");
        } else if (org.equals("") || org == null) {
            this.statusLabel.setText("Enter your org.");
        } else if (org.length() < 5) {
            this.statusLabel.setText("Org too short.");
        } else if (org.length() > 100) {
            this.statusLabel.setText("Org too long.");
        } else if (sid.equals("") || sid == null) {
            this.statusLabel.setText("Enter your SID.");
        } else if (sid.length() != 19) {
            this.statusLabel.setText("Enter a real SID.");
        } else {
            LicenseFile key = new LicenseFile();
            this.keyBox.setText(key.genLicense(name, email, org, sid));
            this.statusLabel.setText("Key successfully generated.");
        }
    }

    private final boolean showFileChooser() {
        JFrame mainFrame = MainApp.getApplication().getMainFrame();
        JarFileFilter filter = new JarFileFilter();
        boolean ret = false;
        File file = null;
        if (this.firstTimeCallingFChooser) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileFilter(filter);
            this.firstTimeCallingFChooser = false;
        }
        this.fileChooser.setDialogTitle("Select the Jar File to Patch");
        this.fileChooser.setFileSelectionMode(2);
        int returnVal = this.fileChooser.showOpenDialog(mainFrame);
        if (returnVal == 1) {
            return false;
        }
        do {
            if (!(file = this.fileChooser.getSelectedFile()).isDirectory()) {
                if (!file.getName().endsWith(".jar")) {
                    this.statusLabel.setText("Select a '.jar' file.");
                    break;
                }
                if (!file.getName().equals("atlassian-extras-2.5.jar")) {
                    this.statusLabel.setText("Select 'atlassian-extras-2.5.jar'.");
                    break;
                }
                this.jarFilePath = file.getAbsolutePath();
                ret = true;
                break;
            }
            this.fileChooser.setCurrentDirectory(file);
            returnVal = this.fileChooser.showOpenDialog(mainFrame);
        } while (returnVal == 0);
        return ret;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.appNameLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.cancelButton = new JButton();
        this.genButton = new JButton();
        this.statusLabel = new JLabel();
        this.keyLabel = new JLabel();
        this.keyBoxScrollPane = new JScrollPane();
        this.keyBox = new JTextArea();
        this.aboutButton = new JButton();
        this.patchButton = new JButton();
        this.emailText = new JTextField();
        this.emailLabel = new JLabel();
        this.orgLabel = new JLabel();
        this.orgText = new JTextField();
        this.serverIDText = new JTextField();
        this.serverIDLabel = new JLabel();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(MainApp.class).getContext().getResourceMap(MainWindow.class);
        this.appNameLabel.setFont(resourceMap.getFont("appNameLabel.font"));
        this.appNameLabel.setText(resourceMap.getString("appNameLabel.text", new Object[0]));
        this.appNameLabel.setName("appNameLabel");
        this.nameLabel.setFont(resourceMap.getFont("nameLabel.font"));
        this.nameLabel.setText(resourceMap.getString("nameLabel.text", new Object[0]));
        this.nameLabel.setName("nameLabel");
        this.nameText.setFont(resourceMap.getFont("nameText.font"));
        this.nameText.setText(resourceMap.getString("nameText.text", new Object[0]));
        this.nameText.setToolTipText(resourceMap.getString("nameText.toolTipText", new Object[0]));
        this.nameText.setName(System.getProperty("user.name"));
        this.nameText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.nameTextMouseClicked(evt);
            }
        });
        ApplicationActionMap actionMap = Application.getInstance(MainApp.class).getContext().getActionMap(MainWindow.class, this);
        this.cancelButton.setAction(actionMap.get("quit"));
        this.cancelButton.setFont(resourceMap.getFont("cancelButton.font"));
        this.cancelButton.setText(resourceMap.getString("cancelButton.text", new Object[0]));
        this.cancelButton.setToolTipText(resourceMap.getString("cancelButton.toolTipText", new Object[0]));
        this.cancelButton.setName("cancelButton");
        this.genButton.setAction(actionMap.get("genLicense"));
        this.genButton.setFont(resourceMap.getFont("genButton.font"));
        this.genButton.setText(resourceMap.getString("genButton.text", new Object[0]));
        this.genButton.setToolTipText(resourceMap.getString("genButton.toolTipText", new Object[0]));
        this.genButton.setName("genButton");
        this.statusLabel.setFont(resourceMap.getFont("statusLabel.font"));
        this.statusLabel.setText(resourceMap.getString("statusLabel.text", new Object[0]));
        this.statusLabel.setName("statusLabel");
        this.keyLabel.setFont(resourceMap.getFont("keyLabel.font"));
        this.keyLabel.setText(resourceMap.getString("keyLabel.text", new Object[0]));
        this.keyLabel.setName("keyLabel");
        this.keyBoxScrollPane.setName("keyBoxScrollPane");
        this.keyBox.setColumns(20);
        this.keyBox.setEditable(false);
        this.keyBox.setFont(resourceMap.getFont("keyBox.font"));
        this.keyBox.setLineWrap(true);
        this.keyBox.setRows(5);
        this.keyBox.setToolTipText(resourceMap.getString("keyBox.toolTipText", new Object[0]));
        this.keyBox.setName("keyBox");
        this.keyBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.keyBoxMouseClicked(evt);
            }
        });
        this.keyBoxScrollPane.setViewportView(this.keyBox);
        this.aboutButton.setAction(actionMap.get("showAboutBox"));
        this.aboutButton.setFont(resourceMap.getFont("aboutButton.font"));
        this.aboutButton.setText(resourceMap.getString("aboutButton.text", new Object[0]));
        this.aboutButton.setToolTipText(resourceMap.getString("aboutButton.toolTipText", new Object[0]));
        this.aboutButton.setName("aboutButton");
        this.patchButton.setAction(actionMap.get("patchApp"));
        this.patchButton.setFont(resourceMap.getFont("patchButton.font"));
        this.patchButton.setText(resourceMap.getString("patchButton.text", new Object[0]));
        this.patchButton.setToolTipText(resourceMap.getString("patchButton.toolTipText", new Object[0]));
        this.patchButton.setName("patchButton");
        this.emailText.setFont(resourceMap.getFont("emailText.font"));
        this.emailText.setText(resourceMap.getString("emailText.text", new Object[0]));
        this.emailText.setToolTipText(resourceMap.getString("emailText.toolTipText", new Object[0]));
        this.emailText.setName("emailText");
        this.emailText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.emailTextMouseClicked(evt);
            }
        });
        this.emailLabel.setFont(resourceMap.getFont("emailLabel.font"));
        this.emailLabel.setText(resourceMap.getString("emailLabel.text", new Object[0]));
        this.emailLabel.setName("emailLabel");
        this.orgLabel.setFont(resourceMap.getFont("orgLabel.font"));
        this.orgLabel.setText(resourceMap.getString("orgLabel.text", new Object[0]));
        this.orgLabel.setName("orgLabel");
        this.orgText.setFont(resourceMap.getFont("orgText.font"));
        this.orgText.setText(resourceMap.getString("orgText.text", new Object[0]));
        this.orgText.setToolTipText(resourceMap.getString("orgText.toolTipText", new Object[0]));
        this.orgText.setName("orgText");
        this.orgText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.orgTextMouseClicked(evt);
            }
        });
        this.serverIDText.setFont(resourceMap.getFont("serverIDText.font"));
        this.serverIDText.setToolTipText(resourceMap.getString("serverIDText.toolTipText", new Object[0]));
        this.serverIDText.setName("serverIDText");
        this.serverIDLabel.setFont(resourceMap.getFont("serverIDLabel.font"));
        this.serverIDLabel.setText(resourceMap.getString("serverIDLabel.text", new Object[0]));
        this.serverIDLabel.setName("serverIDLabel");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.appNameLabel, -1, 432, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.emailLabel).addComponent(this.orgLabel).addComponent(this.serverIDLabel).addComponent(this.keyLabel)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.serverIDText, GroupLayout.Alignment.LEADING, -1, 349, Short.MAX_VALUE).addComponent(this.orgText, GroupLayout.Alignment.LEADING, -1, 349, Short.MAX_VALUE).addComponent(this.emailText, GroupLayout.Alignment.LEADING, -1, 349, Short.MAX_VALUE).addComponent(this.nameText, GroupLayout.Alignment.LEADING, -1, 349, Short.MAX_VALUE).addComponent(this.keyBoxScrollPane, GroupLayout.Alignment.LEADING, -1, 349, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.statusLabel, -1, 126, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.genButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.patchButton).addGap(18, 18, 18).addComponent(this.aboutButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.appNameLabel).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.emailLabel).addComponent(this.emailText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.orgLabel).addComponent(this.orgText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverIDLabel).addComponent(this.serverIDText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keyLabel).addComponent(this.keyBoxScrollPane, -2, -1, -2)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.aboutButton).addComponent(this.patchButton).addComponent(this.genButton).addComponent(this.statusLabel)).addContainerGap()));
        this.setComponent(this.mainPanel);
    }

    private void keyBoxMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            String key = this.keyBox.getText().trim();
            if (key.equals("") || key == null) {
                return;
            }
            this.keyBox.requestFocus();
            this.keyBox.selectAll();
            this.keyBox.copy();
            this.keyBox.select(0, 0);
            this.statusLabel.setText("Key copied to clipboard.");
        }
    }

    private void orgTextMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && this.orgText.getText().equals("iNViSiBLE TEAM")) {
            this.orgText.setText("");
        }
    }

    private void emailTextMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && this.emailText.getText().equals("invisible@scene.nl")) {
            this.emailText.setText("");
        }
    }

    private void nameTextMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && this.nameText.getText().equals(System.getProperty("user.name"))) {
            this.nameText.setText("");
        }
    }
}

